Option Strict Off
Option Explicit On 
Imports System.IO
Friend Class frmAlgoritmiArray
	Inherits System.Windows.Forms.Form
#Region "Windows Form Designer generated code "
	Public Sub New()
		MyBase.New()
		If m_vb6FormDefInstance Is Nothing Then
			If m_InitializingDefInstance Then
				m_vb6FormDefInstance = Me
			Else
				Try 
					'For the start-up form, the first instance created is the default instance.
					If System.Reflection.Assembly.GetExecutingAssembly.EntryPoint.DeclaringType Is Me.GetType Then
						m_vb6FormDefInstance = Me
					End If
				Catch
				End Try
			End If
		End If
		'This call is required by the Windows Form Designer.
		InitializeComponent()
	End Sub
	'Form overrides dispose to clean up the component list.
	Protected Overloads Overrides Sub Dispose(ByVal Disposing As Boolean)
		If Disposing Then
			If Not components Is Nothing Then
				components.Dispose()
			End If
		End If
		MyBase.Dispose(Disposing)
	End Sub
	'Required by the Windows Form Designer
	Private components As System.ComponentModel.IContainer
	Public ToolTip1 As System.Windows.Forms.ToolTip
	Public WithEvents cmdAzzera As System.Windows.Forms.Button
	Public WithEvents cmdCercaNumero As System.Windows.Forms.Button
	Public WithEvents cmdTrovaMax As System.Windows.Forms.Button
	Public WithEvents cmdOrdina As System.Windows.Forms.Button
    Public WithEvents cmdEsegui As System.Windows.Forms.Button
    Public WithEvents lblMessaggio As System.Windows.Forms.Label
	'NOTE: The following procedure is required by the Windows Form Designer
	'It can be modified using the Windows Form Designer.
	'Do not modify it using the code editor.
    Friend WithEvents cmbElenco As System.Windows.Forms.ComboBox
    Friend WithEvents cmbOperazione As System.Windows.Forms.ComboBox
    Public WithEvents btnCalcola As System.Windows.Forms.Button
    Public WithEvents btnElimina As System.Windows.Forms.Button
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
    Friend WithEvents mnuFile As System.Windows.Forms.MenuItem
    Friend WithEvents mnuFileEsci As System.Windows.Forms.MenuItem
    Public WithEvents bntLeggi As System.Windows.Forms.Button
    Public WithEvents btnSalva As System.Windows.Forms.Button
    Friend WithEvents OFDNumeri As System.Windows.Forms.OpenFileDialog
    Friend WithEvents SFDNumeri As System.Windows.Forms.SaveFileDialog
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Me.ToolTip1 = New System.Windows.Forms.ToolTip(Me.components)
        Me.cmdAzzera = New System.Windows.Forms.Button()
        Me.cmdCercaNumero = New System.Windows.Forms.Button()
        Me.cmdTrovaMax = New System.Windows.Forms.Button()
        Me.cmdOrdina = New System.Windows.Forms.Button()
        Me.cmdEsegui = New System.Windows.Forms.Button()
        Me.lblMessaggio = New System.Windows.Forms.Label()
        Me.cmbElenco = New System.Windows.Forms.ComboBox()
        Me.cmbOperazione = New System.Windows.Forms.ComboBox()
        Me.btnCalcola = New System.Windows.Forms.Button()
        Me.btnElimina = New System.Windows.Forms.Button()
        Me.MainMenu1 = New System.Windows.Forms.MainMenu()
        Me.mnuFile = New System.Windows.Forms.MenuItem()
        Me.mnuFileEsci = New System.Windows.Forms.MenuItem()
        Me.bntLeggi = New System.Windows.Forms.Button()
        Me.btnSalva = New System.Windows.Forms.Button()
        Me.OFDNumeri = New System.Windows.Forms.OpenFileDialog()
        Me.SFDNumeri = New System.Windows.Forms.SaveFileDialog()
        Me.SuspendLayout()
        '
        'cmdAzzera
        '
        Me.cmdAzzera.BackColor = System.Drawing.SystemColors.Control
        Me.cmdAzzera.Cursor = System.Windows.Forms.Cursors.Default
        Me.cmdAzzera.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdAzzera.ForeColor = System.Drawing.SystemColors.ControlText
        Me.cmdAzzera.Location = New System.Drawing.Point(400, 80)
        Me.cmdAzzera.Name = "cmdAzzera"
        Me.cmdAzzera.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdAzzera.Size = New System.Drawing.Size(81, 49)
        Me.cmdAzzera.TabIndex = 5
        Me.cmdAzzera.Text = "Azzera Listbox"
        '
        'cmdCercaNumero
        '
        Me.cmdCercaNumero.BackColor = System.Drawing.SystemColors.Control
        Me.cmdCercaNumero.Cursor = System.Windows.Forms.Cursors.Default
        Me.cmdCercaNumero.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdCercaNumero.ForeColor = System.Drawing.SystemColors.ControlText
        Me.cmdCercaNumero.Location = New System.Drawing.Point(496, 16)
        Me.cmdCercaNumero.Name = "cmdCercaNumero"
        Me.cmdCercaNumero.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdCercaNumero.Size = New System.Drawing.Size(81, 49)
        Me.cmdCercaNumero.TabIndex = 3
        Me.cmdCercaNumero.Text = "Cerca Numero"
        '
        'cmdTrovaMax
        '
        Me.cmdTrovaMax.BackColor = System.Drawing.SystemColors.Control
        Me.cmdTrovaMax.Cursor = System.Windows.Forms.Cursors.Default
        Me.cmdTrovaMax.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdTrovaMax.ForeColor = System.Drawing.SystemColors.ControlText
        Me.cmdTrovaMax.Location = New System.Drawing.Point(400, 16)
        Me.cmdTrovaMax.Name = "cmdTrovaMax"
        Me.cmdTrovaMax.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdTrovaMax.Size = New System.Drawing.Size(81, 49)
        Me.cmdTrovaMax.TabIndex = 2
        Me.cmdTrovaMax.Text = "Trova Max"
        '
        'cmdOrdina
        '
        Me.cmdOrdina.BackColor = System.Drawing.SystemColors.Control
        Me.cmdOrdina.Cursor = System.Windows.Forms.Cursors.Default
        Me.cmdOrdina.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdOrdina.ForeColor = System.Drawing.SystemColors.ControlText
        Me.cmdOrdina.Location = New System.Drawing.Point(304, 80)
        Me.cmdOrdina.Name = "cmdOrdina"
        Me.cmdOrdina.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdOrdina.Size = New System.Drawing.Size(81, 49)
        Me.cmdOrdina.TabIndex = 4
        Me.cmdOrdina.Text = "Ordina"
        '
        'cmdEsegui
        '
        Me.cmdEsegui.BackColor = System.Drawing.SystemColors.Control
        Me.cmdEsegui.Cursor = System.Windows.Forms.Cursors.Default
        Me.cmdEsegui.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdEsegui.ForeColor = System.Drawing.SystemColors.ControlText
        Me.cmdEsegui.Location = New System.Drawing.Point(304, 16)
        Me.cmdEsegui.Name = "cmdEsegui"
        Me.cmdEsegui.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdEsegui.Size = New System.Drawing.Size(81, 49)
        Me.cmdEsegui.TabIndex = 1
        Me.cmdEsegui.Text = "Inserisci"
        '
        'lblMessaggio
        '
        Me.lblMessaggio.BackColor = System.Drawing.SystemColors.Control
        Me.lblMessaggio.Cursor = System.Windows.Forms.Cursors.Default
        Me.lblMessaggio.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblMessaggio.ForeColor = System.Drawing.SystemColors.ControlText
        Me.lblMessaggio.Location = New System.Drawing.Point(296, 320)
        Me.lblMessaggio.Name = "lblMessaggio"
        Me.lblMessaggio.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.lblMessaggio.Size = New System.Drawing.Size(272, 80)
        Me.lblMessaggio.TabIndex = 7
        '
        'cmbElenco
        '
        Me.cmbElenco.DropDownStyle = System.Windows.Forms.ComboBoxStyle.Simple
        Me.cmbElenco.Location = New System.Drawing.Point(16, 24)
        Me.cmbElenco.Name = "cmbElenco"
        Me.cmbElenco.Size = New System.Drawing.Size(248, 368)
        Me.cmbElenco.TabIndex = 0
        '
        'cmbOperazione
        '
        Me.cmbOperazione.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList
        Me.cmbOperazione.Items.AddRange(New Object() {"Massimo", "Media", "Minimo", "Somma"})
        Me.cmbOperazione.Location = New System.Drawing.Point(400, 232)
        Me.cmbOperazione.Name = "cmbOperazione"
        Me.cmbOperazione.Size = New System.Drawing.Size(176, 22)
        Me.cmbOperazione.TabIndex = 8
        '
        'btnCalcola
        '
        Me.btnCalcola.BackColor = System.Drawing.SystemColors.Control
        Me.btnCalcola.Cursor = System.Windows.Forms.Cursors.Default
        Me.btnCalcola.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.btnCalcola.ForeColor = System.Drawing.SystemColors.ControlText
        Me.btnCalcola.Location = New System.Drawing.Point(304, 208)
        Me.btnCalcola.Name = "btnCalcola"
        Me.btnCalcola.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.btnCalcola.Size = New System.Drawing.Size(81, 49)
        Me.btnCalcola.TabIndex = 9
        Me.btnCalcola.Text = "Calcola"
        '
        'btnElimina
        '
        Me.btnElimina.BackColor = System.Drawing.SystemColors.Control
        Me.btnElimina.Cursor = System.Windows.Forms.Cursors.Default
        Me.btnElimina.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.btnElimina.ForeColor = System.Drawing.SystemColors.ControlText
        Me.btnElimina.Location = New System.Drawing.Point(496, 80)
        Me.btnElimina.Name = "btnElimina"
        Me.btnElimina.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.btnElimina.Size = New System.Drawing.Size(81, 49)
        Me.btnElimina.TabIndex = 10
        Me.btnElimina.Text = "Elimina"
        '
        'MainMenu1
        '
        Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile})
        '
        'mnuFile
        '
        Me.mnuFile.Index = 0
        Me.mnuFile.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFileEsci})
        Me.mnuFile.Text = "File"
        '
        'mnuFileEsci
        '
        Me.mnuFileEsci.Index = 0
        Me.mnuFileEsci.Text = "Esci"
        '
        'bntLeggi
        '
        Me.bntLeggi.BackColor = System.Drawing.SystemColors.Control
        Me.bntLeggi.Cursor = System.Windows.Forms.Cursors.Default
        Me.bntLeggi.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.bntLeggi.ForeColor = System.Drawing.SystemColors.ControlText
        Me.bntLeggi.Location = New System.Drawing.Point(304, 144)
        Me.bntLeggi.Name = "bntLeggi"
        Me.bntLeggi.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.bntLeggi.Size = New System.Drawing.Size(81, 49)
        Me.bntLeggi.TabIndex = 11
        Me.bntLeggi.Text = "Leggi"
        '
        'btnSalva
        '
        Me.btnSalva.BackColor = System.Drawing.SystemColors.Control
        Me.btnSalva.Cursor = System.Windows.Forms.Cursors.Default
        Me.btnSalva.Font = New System.Drawing.Font("Arial", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.btnSalva.ForeColor = System.Drawing.SystemColors.ControlText
        Me.btnSalva.Location = New System.Drawing.Point(400, 144)
        Me.btnSalva.Name = "btnSalva"
        Me.btnSalva.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.btnSalva.Size = New System.Drawing.Size(81, 49)
        Me.btnSalva.TabIndex = 12
        Me.btnSalva.Text = "Salva"
        '
        'OFDNumeri
        '
        Me.OFDNumeri.Filter = "File di testo (*.txt)|*.txt|Tutti i file (*.*)|*.*"
        '
        'SFDNumeri
        '
        Me.SFDNumeri.Filter = "File di testo (*.txt)|*.txt|Tutti i file (*.*)|"
        '
        'frmAlgoritmiArray
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(600, 437)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.btnSalva, Me.bntLeggi, Me.btnElimina, Me.btnCalcola, Me.cmbOperazione, Me.cmbElenco, Me.cmdAzzera, Me.cmdCercaNumero, Me.cmdTrovaMax, Me.cmdOrdina, Me.cmdEsegui, Me.lblMessaggio})
        Me.Font = New System.Drawing.Font("Arial", 8.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Location = New System.Drawing.Point(4, 23)
        Me.Menu = Me.MainMenu1
        Me.Name = "frmAlgoritmiArray"
        Me.Text = "Alcuni algoritmi con array"
        Me.ResumeLayout(False)

    End Sub
#End Region 
#Region "Upgrade Support "
	Private Shared m_vb6FormDefInstance As frmAlgoritmiArray
	Private Shared m_InitializingDefInstance As Boolean
	Public Shared Property DefInstance() As frmAlgoritmiArray
		Get
			If m_vb6FormDefInstance Is Nothing OrElse m_vb6FormDefInstance.IsDisposed Then
				m_InitializingDefInstance = True
				m_vb6FormDefInstance = New frmAlgoritmiArray()
				m_InitializingDefInstance = False
			End If
			DefInstance = m_vb6FormDefInstance
		End Get
		Set
			m_vb6FormDefInstance = Value
		End Set
	End Property
#End Region 
	Private Structure ElemPosiz
		Dim Elem As Single
        Dim Posiz As Integer
    End Structure
    Const maxNumElementi As Integer = 100
    Dim matrNumeri(maxNumElementi) As Single
    Dim numElementi As Integer
    Dim datiModificati As Boolean = False

    Private Sub cmdAzzera_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdAzzera.Click
        Dim dlgResult As DialogResult

        dlgResult = MessageBox.Show("Sei sicuro?", "", MessageBoxButtons.YesNo, MessageBoxIcon.Question)
        If dlgResult = DialogResult.Yes Then
            RichiediSalvataggio()
            numElementi = 0
            cmbElenco.Items.Clear()
            cmbElenco.Text = ""
            lblMessaggio.Text = ""
        Else
            lblMessaggio.Text = "Operazione di cancellazione annullata"
        End If

        cmbElenco.Focus()
    End Sub

    Private Sub cmdCercaNumero_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdCercaNumero.Click
        Dim Posiz As Integer
        Dim numero As Single
        Dim s As String

        If numElementi > 0 Then
            s = cmbElenco.Text
            If IsNumeric(s) Then
                numero = CSng(s)
                Posiz = TrovaNumero(matrNumeri, numElementi, numero)
                If Posiz > 0 Then
                    cmbElenco.SelectedIndex = Posiz - 1
                    lblMessaggio.Text = "Il numero " & numero & "  presente in posizione " & Posiz
                Else
                    cmbElenco.SelectedIndex = -1
                    lblMessaggio.Text = "Il numero cercato non  presente"
                End If
            Else
                MessageBox.Show("E' necessario inserire un numero!", "Errore")
                cmbElenco.Focus()
            End If
        Else
            lblMessaggio.Text = "Non ci sono elementi"
        End If
    End Sub

    Private Sub cmdEsegui_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdEsegui.Click
        Dim s As String

        s = cmbElenco.Text
        If IsNumeric(s) Then
            If numElementi <= maxNumElementi Then
                numElementi = numElementi + 1
                matrNumeri(numElementi) = CSng(s)
                cmbElenco.Items.Add(CStr(matrNumeri(numElementi)))
                datiModificati = True
            Else
                MessageBox.Show("Attenzione: dimensione massima array superata!", "Errore")
            End If
        Else
            MessageBox.Show("E' necessario inserire un numero!", "Errore")
        End If
        cmbElenco.Focus()
    End Sub

    Private Sub cmdOrdina_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdOrdina.Click
        If numElementi > 0 Then
            OrdinaVett(matrNumeri, numElementi)
            cmbElenco.Items.Clear()
            AggiungiElementi(matrNumeri, numElementi)
            lblMessaggio.Text = "I numeri in elenco sono stati ordinati"
        Else
            lblMessaggio.Text = "Non ci sono elementi"
        End If
    End Sub

    Private Sub cmdTrovaMax_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdTrovaMax.Click
        Dim maxInd As ElemPosiz

        If numElementi > 0 Then
            maxInd = TrovaMax(matrNumeri, numElementi)
            cmbElenco.SelectedIndex = maxInd.Posiz - 1
            lblMessaggio.Text = "Il massimo  " & maxInd.Elem & " e si trova in posizione " & maxInd.Posiz
        Else
            lblMessaggio.Text = "Non ci sono elementi"
        End If
    End Sub

    Private Sub frmAlgoritmiArray_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
        numElementi = 0
        OFDNumeri.InitialDirectory = Application.StartupPath
        SFDNumeri.InitialDirectory = Application.StartupPath
    End Sub

    Private Sub AggiungiElementi(ByVal matrNumeri() As Single, ByVal numElementi As Integer)
        Dim i As Integer

        For i = 1 To numElementi
            cmbElenco.Items.Add(CStr(matrNumeri(i)))
        Next i
    End Sub

    Private Function Somma(ByVal matrNumeri() As Single, ByVal numElementi As Integer) As Single
        Dim i As Integer

        Somma = 0
        For i = 1 To numElementi
            Somma = Somma + matrNumeri(i)
        Next
        Return Somma
    End Function

    Private Function TrovaMax(ByVal matrNumeri() As Single, ByVal numElementi As Integer) As ElemPosiz
        Dim i As Integer
        Dim maxInd As ElemPosiz

        maxInd.Elem = matrNumeri(1)
        maxInd.Posiz = 1
        For i = 2 To numElementi
            If matrNumeri(i) > maxInd.Elem Then
                maxInd.Elem = matrNumeri(i)
                maxInd.Posiz = i
            End If
        Next i
        TrovaMax = maxInd
    End Function

    Private Function TrovaMin(ByVal matrNumeri() As Single, ByVal numElementi As Integer) As ElemPosiz
        Dim i As Integer
        Dim minInd As ElemPosiz

        minInd.Elem = matrNumeri(1)
        minInd.Posiz = 1
        For i = 2 To numElementi
            If matrNumeri(i) < minInd.Elem Then
                minInd.Elem = matrNumeri(i)
                minInd.Posiz = i
            End If
        Next i
        TrovaMin = minInd
    End Function

    Private Sub OrdinaVett(ByVal matrNumeri() As Single, ByVal numElementi As Integer)
        Dim i As Integer
        Dim j As Integer
        Dim s As Single

        For i = 1 To numElementi - 1
            For j = i + 1 To numElementi
                If matrNumeri(j) < matrNumeri(i) Then
                    s = matrNumeri(i)
                    matrNumeri(i) = matrNumeri(j)
                    matrNumeri(j) = s
                End If
            Next j
        Next i

    End Sub

    Private Function TrovaNumero(ByVal matrNumeri() As Single, ByVal numElementi As Integer, ByVal numero As Single) As Integer
        Dim i As Integer
        Dim trovato As Boolean

        i = 1
        trovato = False
        Do While (i <= numElementi) And (Not trovato)
            If matrNumeri(i) = numero Then
                trovato = True
            End If
            i = i + 1
        Loop
        If trovato = False Then
            TrovaNumero = -1
        Else
            TrovaNumero = i - 1
        End If
    End Function

    Private Sub btnCalcola_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCalcola.Click
        Dim minInd As ElemPosiz

        If numElementi > 0 Then
            Select Case cmbOperazione.SelectedIndex
                Case 0
                    cmdTrovaMax_Click(sender, e)
                Case 1
                    lblMessaggio.Text = "La media degli elementi  " & FormatNumber((Somma(matrNumeri, numElementi) / numElementi), 4)
                Case 2
                    minInd = TrovaMin(matrNumeri, numElementi)
                    cmbElenco.SelectedIndex = minInd.Posiz - 1
                    lblMessaggio.Text = "Il minimo  " & minInd.Elem & " e si trova in posizione " & minInd.Posiz
                Case 3
                    lblMessaggio.Text = "La somma degli elementi  " & Somma(matrNumeri, numElementi)
            End Select
        Else
            lblMessaggio.Text = "Non ci sono elementi"
        End If
    End Sub

    Private Sub btnElimina_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnElimina.Click
        Dim i As Integer

        If cmbElenco.SelectedIndex <> -1 Then
            cmbElenco.Items.RemoveAt(cmbElenco.SelectedIndex)
            lblMessaggio.Text = "Elemento eliminato"
            datiModificati = True
            numElementi = numElementi - 1
            For i = 1 To numElementi
                matrNumeri(i) = CSng(cmbElenco.Items(i - 1))
            Next
        Else
            lblMessaggio.Text = "Selezionare un elemento prima di rimuoverlo"
        End If
    End Sub

    Private Sub mnuFileEsci_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuFileEsci.Click
        Close()
    End Sub

    Private Sub bntLeggi_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bntLeggi.Click
        Dim dlgResult As DialogResult

        RichiediSalvataggio()
        dlgResult = OFDNumeri.ShowDialog
        If dlgResult <> DialogResult.Cancel Then
            Try
                Dim datNumeri As New StreamReader(OFDNumeri.FileName)
                numElementi = 0
                Do While datNumeri.Peek <> -1 And numElementi <= maxNumElementi
                    numElementi = numElementi + 1
                    matrNumeri(numElementi) = CSng(datNumeri.ReadLine)
                    cmbElenco.Items.Add(CStr(matrNumeri(numElementi)))
                Loop
                If numElementi > maxNumElementi Then
                    MessageBox.Show("Attenzione: dimensione massima array superata!", "Errore")
                End If
                datNumeri.Close()
            Catch
                MessageBox.Show("Errore file", "Errore")
            End Try
        End If
    End Sub

    Private Sub btnSalva_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSalva.Click
        Salva()
    End Sub

    Private Sub frmAlgoritmiArray_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
        RichiediSalvataggio()
    End Sub

    Private Sub RichiediSalvataggio()
        Dim dlgResult As DialogResult
        If datiModificati Then
            dlgResult = MessageBox.Show("Si desidera salvare il contenuto?", "", MessageBoxButtons.YesNo, MessageBoxIcon.Question)
            If dlgResult = DialogResult.Yes Then
                Salva()
            End If
        End If
    End Sub

    Private Sub Salva()
        Dim i As Integer
        Dim dlgResult As DialogResult
        If numElementi > 0 Then
            dlgResult = SFDNumeri.ShowDialog
            If dlgResult <> DialogResult.Cancel Then
                Dim datNumeri As New StreamWriter(SFDNumeri.FileName)
                Try
                    For i = 1 To numElementi
                        datNumeri.WriteLine(matrNumeri(i))
                    Next
                    datNumeri.Close()
                    datiModificati = False
                Catch
                    MessageBox.Show("Errore nella scrittura del file", "errore")
                End Try
            Else
                lblMessaggio.Text = "Operazione di salvataggio annullata"
            End If
        Else
            lblMessaggio.Text = "Non ci sono elementi"
        End If
    End Sub
End Class